/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GameOfLife
extends JFrame {
    GamePanel panel;
    JScrollPane jsPane;
    Timer timer;
    static int[] glidery = new int[]{2, 3, 1, 3, 3};
    static int[] gliderx = new int[]{1, 1, 2, 2, 3};
    static int[] guny = new int[]{5, 6, 5, 6, 5, 6, 7, 4, 8, 3, 9, 3, 9, 6, 4, 8, 5, 6, 7, 6, 3, 4, 5, 3, 4, 5, 2, 6, 1, 2, 6, 7, 3, 4, 3, 4};
    static int[] gunx = new int[]{1, 1, 2, 2, 11, 11, 11, 12, 12, 13, 13, 14, 14, 15, 16, 16, 17, 17, 17, 18, 21, 21, 21, 22, 22, 22, 23, 23, 25, 25, 25, 25, 35, 35, 36, 36};

    public static void main(String[] args) {
        new GameOfLife();
    }

    public GameOfLife() {
        int cols;
        int rows;
        this.setTitle("Game of Life");
        this.setDefaultCloseOperation(3);
        this.setLayout(new FlowLayout());
        this.setLocationRelativeTo(null);
        this.setSize(new Dimension(500, 500));
        this.setMinimumSize(new Dimension(500, 500));
        try {
            rows = Integer.parseInt(JOptionPane.showInputDialog("Input the number of rows"));
            cols = Integer.parseInt(JOptionPane.showInputDialog("Input the number of columns"));
        }
        catch (NumberFormatException nfex) {
            rows = 200;
            cols = 200;
            JOptionPane.showMessageDialog(null, "Invalid Input! Use default settings.");
        }
        if (rows < 50) {
            rows = 50;
        }
        if (cols < 50) {
            cols = 50;
        }
        this.panel = new GamePanel(rows, cols);
        this.jsPane = new JScrollPane(this.panel);
        this.jsPane.setPreferredSize(new Dimension(500, 400));
        this.add(this.jsPane);
        this.add(this.panel.jtf);
        this.add(this.panel.jbtNext);
        this.add(this.panel.jbtAuto);
        this.add(this.panel.jlb2);
        this.add(this.panel.jcb);
        this.add(this.panel.jlb);
        this.setVisible(true);
    }

    private class GamePanel
    extends JPanel {
        private int rows;
        private int cols;
        Cell[][] cells;
        private Color aliveColor = new Color(0, 200, 15);
        private Color selectedColor = new Color(255, 255, 15);
        private Color selectedRectColor = new Color(255, 255, 15, 100);
        private Cell selectedCell = null;
        private Point selectedRectPos0 = null;
        private Point selectedRectPos1 = null;
        ArrayList<Cell> updateList = new ArrayList();
        private int sidelen = 8;
        private long generation = 0L;
        private JComboBox jcb;
        JTextField jtf;
        JButton jbtNext;
        JButton jbtAuto;
        Object[] jcbItems = new Object[]{"Single Cell", "Glider", "Gosper Gun", "Erase"};
        private JLabel jlb;
        private JLabel jlb2;
        TimerTask task;

        public GamePanel(int rs, int cs) {
            this.rows = rs;
            this.cols = cs;
            this.cells = new Cell[this.rows][this.cols];
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    this.cells[i][j] = new Cell(i, j);
                    ++j;
                }
                ++i;
            }
            this.setFocusable(true);
            this.setPreferredSize(new Dimension(this.cols * this.sidelen, this.rows * this.sidelen));
            this.setOpaque(true);
            this.setBackground(new Color(15, 15, 15));
            this.setForeground(new Color(200, 200, 200));
            this.jcb = new JComboBox<Object>(this.jcbItems);
            this.jcb.setPreferredSize(new Dimension(180, 20));
            this.jlb = new JLabel("generation: 0");
            this.jlb.setPreferredSize(new Dimension(160, 20));
            this.jlb2 = new JLabel();
            this.jlb2.setPreferredSize(new Dimension(80, 20));
            this.jtf = new JTextField();
            this.jtf.setText("50");
            this.jtf.setPreferredSize(new Dimension(50, 20));
            this.jtf.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        if (GamePanel.this.jbtAuto.getText().equals("Stop")) {
                            GamePanel.this.task.cancel();
                            ((GamePanel)GamePanel.this).GameOfLife.this.timer.purge();
                        }
                        GamePanel.this.jbtAuto.setText("Stop");
                        int tm = Integer.parseInt(GamePanel.this.jtf.getText());
                        if (tm < 40) {
                            tm = 40;
                            GamePanel.this.jtf.setText("40");
                        }
                        GamePanel.this.task = new TimerTask(){

                            public void run() {
                                GamePanel.this.nextStep();
                            }
                        };
                        ((GamePanel)GamePanel.this).GameOfLife.this.timer.schedule(GamePanel.this.task, 0L, (long)tm);
                    }
                }
            });
            this.jbtNext = new JButton();
            this.jbtNext.setText("Next");
            this.jbtNext.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent ev) {
                    GamePanel.this.nextStep();
                }
            });
            GameOfLife.this.timer = new Timer();
            this.jbtAuto = new JButton();
            this.jbtAuto.setText("Start");
            this.jbtAuto.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent ev) {
                    if (GamePanel.this.jbtAuto.getText().equals("Start")) {
                        GamePanel.this.jbtAuto.setText("Stop");
                        int tm = Integer.parseInt(GamePanel.this.jtf.getText());
                        if (tm < 40) {
                            tm = 40;
                            GamePanel.this.jtf.setText("40");
                        }
                        GamePanel.this.task = new TimerTask(){

                            public void run() {
                                GamePanel.this.nextStep();
                            }
                        };
                        ((GamePanel)GamePanel.this).GameOfLife.this.timer.schedule(GamePanel.this.task, 0L, (long)tm);
                    } else {
                        GamePanel.this.jbtAuto.setText("Start");
                        GamePanel.this.task.cancel();
                        ((GamePanel)GamePanel.this).GameOfLife.this.timer.purge();
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    switch (GamePanel.this.jcb.getSelectedIndex()) {
                        case 0: {
                            GamePanel.this.repaint(GamePanel.this.updateNeighbor(GamePanel.this.selectedCell.setAlive()));
                            break;
                        }
                        case 1: {
                            GamePanel.this.addGlider(GamePanel.this.selectedCell, true);
                            GamePanel.this.repaint();
                            break;
                        }
                        case 2: {
                            GamePanel.this.addGun(GamePanel.this.selectedCell, true);
                            GamePanel.this.repaint();
                            break;
                        }
                        case 3: {
                            if (!((GamePanel)GamePanel.this).selectedCell.alive) break;
                            GamePanel.this.repaint(GamePanel.this.updateNeighbor(GamePanel.this.selectedCell.setAlive()));
                        }
                    }
                }

                public void mousePressed(MouseEvent e) {
                    GamePanel.this.selectedRectPos0 = e.getPoint();
                }

                public void mouseReleased(MouseEvent e) {
                    if (GamePanel.this.selectedRectPos1 == null) {
                        return;
                    }
                    int indx = GamePanel.this.jcb.getSelectedIndex();
                    if (indx != 0 && indx != 3) {
                        Object[] options;
                        int option;
                        if (GamePanel.this.jbtAuto.getText().equals("Stop")) {
                            GamePanel.this.jbtAuto.setText("Start");
                            GamePanel.this.task.cancel();
                        }
                        if ((option = JOptionPane.showOptionDialog(null, "Are you sure to clear all in the selected rect?", "Clear Cells", 0, -1, null, options = new Object[]{"Yes", "Cancel"}, options[0])) == 0) {
                            GamePanel.this.clearCells(GamePanel.this.selectedRectPos0, GamePanel.this.selectedRectPos1);
                        }
                        GamePanel.this.selectedRectPos1 = null;
                        GamePanel.this.selectedRectPos0 = null;
                        GamePanel.this.repaint();
                    } else {
                        GamePanel.this.selectedRectPos1 = null;
                        GamePanel.this.selectedRectPos0 = null;
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    GamePanel.this.selectedCell = GamePanel.this.cellAt(e.getX(), e.getY());
                    GamePanel.this.showCoord(GamePanel.this.selectedCell);
                }

                public void mouseExited(MouseEvent e) {
                    GamePanel.this.selectedCell = null;
                    GamePanel.this.selectedRectPos1 = null;
                    GamePanel.this.selectedRectPos0 = null;
                    GamePanel.this.repaint();
                    GamePanel.this.jlb2.setText("");
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent e) {
                    Cell cl = GamePanel.this.cellAt(e.getX(), e.getY());
                    if (cl != GamePanel.this.selectedCell) {
                        GamePanel.this.repaint(GamePanel.this.selectedCell);
                        Cell cell = cl;
                        GamePanel.this.selectedCell = cell;
                        GamePanel.this.repaint(cell);
                        GamePanel.this.showCoord(GamePanel.this.selectedCell);
                    }
                }

                public void mouseDragged(MouseEvent e) {
                    Cell cl = GamePanel.this.cellAt(e.getX(), e.getY());
                    if (GamePanel.this.jcb.getSelectedIndex() == 0) {
                        if (cl == GamePanel.this.selectedCell) {
                            return;
                        }
                        if (!cl.alive) {
                            GamePanel.this.updateNeighbor(cl.setAlive());
                        }
                        GamePanel.this.repaint(GamePanel.this.selectedCell);
                        Cell cell = cl;
                        GamePanel.this.selectedCell = cell;
                        GamePanel.this.repaint(cell);
                        GamePanel.this.showCoord(GamePanel.this.selectedCell);
                    } else if (GamePanel.this.jcb.getSelectedIndex() == 3) {
                        if (cl == GamePanel.this.selectedCell) {
                            return;
                        }
                        if (cl.alive) {
                            GamePanel.this.updateNeighbor(cl.setAlive());
                        }
                        GamePanel.this.repaint(GamePanel.this.selectedCell);
                        Cell cell = cl;
                        GamePanel.this.selectedCell = cell;
                        GamePanel.this.repaint(cell);
                        GamePanel.this.showCoord(GamePanel.this.selectedCell);
                    } else {
                        GamePanel.this.selectedRectPos1 = e.getPoint();
                        if (cl != GamePanel.this.selectedCell) {
                            GamePanel.this.selectedCell = cl;
                            GamePanel.this.showCoord(GamePanel.this.selectedCell);
                        }
                        GamePanel.this.repaint();
                    }
                }
            });
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int i = 0;
            while (i <= this.rows) {
                g.drawLine(0, this.sidelen * i, this.sidelen * this.cols, this.sidelen * i);
                ++i;
            }
            i = 0;
            while (i <= this.cols) {
                g.drawLine(this.sidelen * i, 0, this.sidelen * i, this.sidelen * this.rows);
                ++i;
            }
            g.setColor(this.aliveColor);
            i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    if (this.cells[i][j].alive) {
                        g.fillRect(j * this.sidelen + 1, i * this.sidelen + 1, this.sidelen - 2, this.sidelen - 2);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.selectedCell != null) {
                g.setColor(this.selectedColor);
                g.drawRect(this.selectedCell.c * this.sidelen + 1, this.selectedCell.r * this.sidelen + 1, this.sidelen - 2, this.sidelen - 2);
            }
            if (this.selectedRectPos1 != null && !this.selectedRectPos0.equals(this.selectedRectPos1)) {
                int px = this.selectedRectPos0.x;
                int py = this.selectedRectPos0.y;
                int w = this.selectedRectPos1.x - px;
                int h = this.selectedRectPos1.y - py;
                if (w < 0) {
                    px = this.selectedRectPos1.x;
                    w = -w;
                }
                if (h < 0) {
                    py = this.selectedRectPos1.y;
                    h = -h;
                }
                g.setColor(this.selectedRectColor);
                g.fillRect(px + 1, py + 1, w - 2, h - 2);
            }
        }

        private void repaint(Cell cl) {
            this.repaint(cl.c * this.sidelen, cl.r * this.sidelen, this.sidelen, this.sidelen);
        }

        private Cell cellAt(int x, int y) {
            return this.cells[y / this.sidelen][x / this.sidelen];
        }

        private void updateNeighbor(int i, int j, boolean incr) {
            if (i <= 0 || j <= 0 || i >= this.rows - 1 || j >= this.cols - 1) {
                return;
            }
            if (incr) {
                ++this.cells[i - 1][j - 1].neighbor;
                ++this.cells[i - 1][j].neighbor;
                ++this.cells[i - 1][j + 1].neighbor;
                ++this.cells[i][j - 1].neighbor;
                ++this.cells[i][j + 1].neighbor;
                ++this.cells[i + 1][j - 1].neighbor;
                ++this.cells[i + 1][j].neighbor;
                ++this.cells[i + 1][j + 1].neighbor;
            } else {
                --this.cells[i - 1][j - 1].neighbor;
                --this.cells[i - 1][j].neighbor;
                --this.cells[i - 1][j + 1].neighbor;
                --this.cells[i][j - 1].neighbor;
                --this.cells[i][j + 1].neighbor;
                --this.cells[i + 1][j - 1].neighbor;
                --this.cells[i + 1][j].neighbor;
                --this.cells[i + 1][j + 1].neighbor;
            }
        }

        private Cell updateNeighbor(Cell cl) {
            this.updateNeighbor(cl.r, cl.c, cl.alive);
            return cl;
        }

        private void nextStep() {
            this.nextStep_0();
            this.nextStep_1();
            this.jlb.setText("generation: " + ++this.generation);
            this.repaint();
        }

        private void nextStep_0() {
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    Cell cl = this.cells[i][j];
                    if (cl.alive && (cl.neighbor < 2 || cl.neighbor > 3)) {
                        cl.alive = false;
                        this.updateList.add(cl);
                    } else if (cl.neighbor == 3 && !cl.alive) {
                        cl.alive = true;
                        this.updateList.add(cl);
                    }
                    ++j;
                }
                ++i;
            }
        }

        private void nextStep_1() {
            Iterator<Cell> iter = this.updateList.iterator();
            while (iter.hasNext()) {
                this.updateNeighbor(iter.next());
            }
            this.updateList.clear();
        }

        private void debugCells() {
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    System.out.print(String.valueOf(this.cells[i][j].neighbor) + "\t");
                    ++j;
                }
                System.out.println("");
                ++i;
            }
        }

        private void addCells(int x, int y, boolean hori, int[] cx, int[] cy) {
            int sgnx = 1;
            int sgny = 1;
            if (x < 0) {
                x = -x;
                sgnx = -1;
            }
            if (y < 0) {
                y = -y;
                sgny = -1;
            }
            if (hori) {
                int i = 0;
                while (i < cx.length) {
                    this.updateList.add(this.cells[sgny * cy[i] + y][sgnx * cx[i] + x].setAlive());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < cx.length) {
                    this.updateList.add(this.cells[sgny * cx[i] + y][sgnx * cy[i] + x].setAlive());
                    ++i;
                }
            }
            this.nextStep_1();
        }

        private void addGun(Cell cl, boolean hori) {
            this.addCells(cl.c, cl.r, hori, gunx, guny);
        }

        private void addGlider(Cell cl, boolean hori) {
            this.addCells(cl.c, cl.r, hori, gliderx, glidery);
        }

        private void showCoord(Cell cl) {
            if (cl == null) {
                this.jlb2.setText("");
            }
            this.jlb2.setText("Cell (" + cl.c + "," + cl.r + ")");
        }

        private void clearCells(Point p0, Point p1) {
            int tmp;
            if (p0 == null || p1 == null) {
                return;
            }
            int p0x = p0.x / this.sidelen;
            int p0y = p0.y / this.sidelen;
            int p1x = p1.x / this.sidelen;
            int p1y = p1.y / this.sidelen;
            if (p0x > p1x) {
                tmp = p0x;
                p0x = p1x;
                p1x = tmp;
            }
            if (p0y > p1y) {
                tmp = p0y;
                p0y = p1y;
                p1y = tmp;
            }
            int i = p0y;
            while (i < p1y) {
                int j = p0x;
                while (j < p1x) {
                    if (this.cells[i][j].alive) {
                        this.updateNeighbor(this.cells[i][j].setAlive());
                    }
                    ++j;
                }
                ++i;
            }
        }

        private class Cell {
            public int r = 0;
            public int c = 0;
            public boolean alive = false;
            public int neighbor = 0;

            public Cell(int i, int j) {
                this.r = i;
                this.c = j;
                this.alive = false;
                this.neighbor = 0;
            }

            public Cell setAlive() {
                this.alive = !this.alive;
                return this;
            }

            public String toString() {
                return "[" + this.r + "," + this.c + "]," + this.alive + "," + this.neighbor;
            }
        }
    }
}

